/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.FolderChangeListener;
import net.codestory.http.reload.FolderWatcher;

public class MasterFolderWatch {
    private final List<FolderWatcher> classesWatchers;
    private final List<FolderChangeListener> listeners = new CopyOnWriteArrayList<FolderChangeListener>();

    public MasterFolderWatch(Env env) {
        FolderChangeListener notifyListeners = () -> this.listeners.forEach(listener -> listener.onChange());
        this.classesWatchers = env.foldersToWatch().stream().map(path -> new FolderWatcher((Path)path, notifyListeners)).collect(Collectors.toList());
    }

    public void ensureStarted() {
        this.classesWatchers.forEach(watcher -> watcher.ensureStarted());
    }

    public void stop() {
        this.classesWatchers.forEach(watcher -> watcher.stop());
    }

    public void addListener(FolderChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FolderChangeListener listener) {
        this.listeners.remove(listener);
    }
}

