/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Options;
import java.net.URL;
import java.util.function.Function;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Cache;
import net.codestory.http.misc.WebJarUrlFinder;
import net.codestory.http.templating.helpers.HelperTools;

public class WebjarHelperSource {
    private final WebJarUrlFinder webJarUrlFinder;
    private final Function<String, String> fullPathForUri;

    public WebjarHelperSource(boolean prodMode) {
        this.webJarUrlFinder = new WebJarUrlFinder(prodMode);
        this.fullPathForUri = prodMode ? new Cache<String, String>(uri -> this.fullPathForUri((String)uri)) : uri -> this.fullPathForUri((String)uri);
    }

    public CharSequence webjar(Object context, Options options) {
        String attributes = HelperTools.hashAsString(options);
        return HelperTools.toString(context, value -> this.singleWebjar(value, attributes));
    }

    private String singleWebjar(Object value, String attributes) {
        String fullPath = this.fullPathForUri.apply(value.toString());
        return this.tag(fullPath, attributes);
    }

    private String fullPathForUri(String uri) {
        URL classpathUrl = this.webJarUrlFinder.url(uri);
        if (classpathUrl == null) {
            return uri;
        }
        return Strings.substringAfter(classpathUrl.toString(), "/META-INF/resources");
    }

    private String tag(String fullPath, String attributes) {
        if (fullPath.endsWith(".css")) {
            return "<link rel=\"stylesheet\" href=\"" + fullPath + "\"" + attributes + ">";
        }
        return "<script src=\"" + fullPath + "\"" + attributes + "></script>";
    }
}

