/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.annotations.AllowCredentials;
import net.codestory.http.annotations.AllowHeaders;
import net.codestory.http.annotations.AllowMethods;
import net.codestory.http.annotations.AllowOrigin;
import net.codestory.http.annotations.AnnotationHelper;
import net.codestory.http.annotations.ApplyAfterAnnotation;
import net.codestory.http.annotations.ApplyAroundAnnotation;
import net.codestory.http.annotations.ExposeHeaders;
import net.codestory.http.annotations.MaxAge;
import net.codestory.http.annotations.MethodAnnotationsFactory;
import net.codestory.http.annotations.Resource;
import net.codestory.http.annotations.Roles;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.extensions.Extensions;
import net.codestory.http.filters.Filter;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.injection.Singletons;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.ClasspathScanner;
import net.codestory.http.io.Resources;
import net.codestory.http.livereload.LiveReloadListener;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.BoundFolderRoute;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.ContextToPayload;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteSorter;
import net.codestory.http.routes.RouteWithPattern;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.RoutesWithPattern;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.SourceRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.UriParser;
import net.codestory.http.routes.WebJarsRoute;
import net.codestory.http.security.User;
import net.codestory.http.templating.Site;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketListenerFactory;
import net.codestory.http.websockets.WebSocketSession;

public class RouteCollection
implements Routes {
    protected final Env env;
    protected final Resources resources;
    protected final CompilerFacade compilers;
    protected final Site site;
    protected final MethodAnnotationsFactory methodAnnotationsFactory;
    protected final RouteSorter routes;
    protected final Deque<Supplier<Filter>> filters;
    protected IocAdapter iocAdapter;
    protected Extensions extensions;
    protected WebSocketListenerFactory webSocketListenerFactory;
    protected ContextToPayload contextToPayload;

    public RouteCollection(Env env) {
        this.env = env;
        this.resources = new Resources(env);
        this.compilers = new CompilerFacade(env, this.resources);
        this.site = new Site(env, this.resources);
        this.methodAnnotationsFactory = this.createMethodAnnotationsFactory();
        this.routes = new RouteSorter();
        this.filters = new LinkedList<Supplier<Filter>>();
        this.iocAdapter = new Singletons(new Object[0]);
        this.extensions = new Extensions(){};
        this.webSocketListenerFactory = (session, context) -> {
            throw new UnsupportedOperationException();
        };
    }

    public void configure(Configuration configuration) {
        configuration.configure(this);
        this.installExtensions();
        this.addStaticRoutes();
        this.contextToPayload = RouteCollection.createContextToPayload(this.routes.getSortedRoutes(), this.filters);
    }

    private void installExtensions() {
        TypeConvert.configureOrReplaceMapper(mapper -> this.extensions.configureOrReplaceObjectMapper((ObjectMapper)mapper, this.env));
        this.extensions.configureCompilers(this.compilers, this.env);
    }

    private void addStaticRoutes() {
        this.routes.addStaticRoute(new WebJarsRoute(this.env.prodMode()));
        this.routes.addStaticRoute(new StaticRoute(this.env.prodMode(), this.resources, this.compilers));
        if (!this.env.prodMode()) {
            this.routes.addStaticRoute(new SourceMapRoute(this.resources, this.compilers));
            this.routes.addStaticRoute(new SourceRoute(this.resources));
        }
        if (this.env.liveReloadServer()) {
            this.get("/livereload.js", ClassPaths.getResource("livereload/livereload.js"));
            this.setWebSocketListenerFactory((session, context) -> new LiveReloadListener(session, this.env));
        }
    }

    public PayloadWriter createPayloadWriter(Request request, Response response) {
        return this.extensions.createPayloadWriter(request, response, this.env, this.site, this.resources, this.compilers);
    }

    public Context createContext(Request request, Response response) {
        return this.extensions.createContext(request, response, this.iocAdapter, this.env, this.site);
    }

    @Override
    public RouteCollection setExtensions(Extensions extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    public RouteCollection setIocAdapter(IocAdapter iocAdapter) {
        this.iocAdapter = iocAdapter;
        return this;
    }

    @Override
    public Routes setWebSocketListenerFactory(WebSocketListenerFactory factory) {
        this.webSocketListenerFactory = factory;
        return null;
    }

    @Override
    public RouteCollection filter(Class<? extends Filter> filterClass) {
        this.filters.addFirst(() -> (Filter)this.iocAdapter.get(filterClass));
        return this;
    }

    @Override
    public RouteCollection filter(Filter filter) {
        this.filters.addFirst(() -> filter);
        return this;
    }

    @Override
    public RouteCollection add(Class<?> resourceType) {
        this.addResource("", resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Class<?> resourceType) {
        this.addResource(urlPrefix, resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(Object resource) {
        this.addResource("", resource.getClass(), () -> resource);
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Object resource) {
        this.addResource(urlPrefix, resource.getClass(), () -> resource);
        return this;
    }

    protected void addResource(String urlPrefix, Class<?> resourceType, Supplier<Object> resource) {
        AnnotationHelper.parseAnnotations(urlPrefix, resourceType, (httpMethod, uri, method) -> this.addResource(httpMethod, method, resource, uri));
    }

    protected void addResource(String httpMethod, Method method, Supplier<Object> resource, String uriPattern) {
        int uriParamsCount;
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount < (uriParamsCount = UriParser.paramsCount(uriPattern))) {
            throw new IllegalArgumentException("Expected at least " + uriParamsCount + " parameters in " + uriPattern);
        }
        this.add(httpMethod, uriPattern, new ReflectionRoute(resource, method, this.methodAnnotationsFactory.forMethod(method)));
    }

    @Override
    public RouteCollection get(String uriPattern, Object payload) {
        this.get(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, OneParamRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, FourParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, Object payload) {
        this.options(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRouteWithContext route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, OneParamRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, TwoParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, ThreeParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, FourParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, Object payload) {
        this.head(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRouteWithContext route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, OneParamRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, TwoParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, ThreeParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, FourParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, OneParamRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, FourParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRouteWithContext route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, OneParamRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, TwoParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, ThreeParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, FourParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRouteWithContext route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, OneParamRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, TwoParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, ThreeParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, FourParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public Routes anyGet(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("GET", route));
        return this;
    }

    @Override
    public Routes anyHead(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("HEAD", route));
        return this;
    }

    @Override
    public Routes anyPost(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("POST", route));
        return this;
    }

    @Override
    public Routes anyPut(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("PUT", route));
        return this;
    }

    @Override
    public Routes anyOptions(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("OPTIONS", route));
        return this;
    }

    @Override
    public Routes anyDelete(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute("DELETE", route));
        return this;
    }

    @Override
    public RouteCollection any(NoParamRouteWithContext route) {
        this.routes.addCatchAllRoute(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RouteCollection autoDiscover(String packageToScan) {
        Set<Class<?>> types = new ClasspathScanner().getTypesAnnotatedWith(packageToScan, Resource.class);
        types.forEach(clazz -> this.add((Class)clazz));
        return this;
    }

    @Override
    public Routes bind(String uriRoot, File path) {
        this.routes.addStaticRoute(new BoundFolderRoute(uriRoot, path));
        return this;
    }

    @Override
    public <T extends Annotation> Routes registerAroundAnnotation(Class<T> annotationType, ApplyAroundAnnotation<T> apply) {
        this.methodAnnotationsFactory.registerAroundAnnotation(annotationType, () -> apply);
        return this;
    }

    @Override
    public <T extends Annotation> Routes registerAroundAnnotation(Class<T> annotationType, Class<? extends ApplyAroundAnnotation<T>> applyType) {
        this.methodAnnotationsFactory.registerAroundAnnotation(annotationType, () -> (ApplyAroundAnnotation)this.iocAdapter.get(applyType));
        return this;
    }

    @Override
    public <T extends Annotation> Routes registerAfterAnnotation(Class<T> annotationType, ApplyAfterAnnotation<T> apply) {
        this.methodAnnotationsFactory.registerAfterAnnotation(annotationType, () -> apply);
        return this;
    }

    @Override
    public <T extends Annotation> Routes registerAfterAnnotation(Class<T> annotationType, Class<? extends ApplyAfterAnnotation<T>> applyType) {
        this.methodAnnotationsFactory.registerAfterAnnotation(annotationType, () -> (ApplyAfterAnnotation)this.iocAdapter.get(applyType));
        return this;
    }

    @Override
    public RoutesWithPattern url(String uriPattern) {
        return new RoutesWithPattern(this, uriPattern);
    }

    protected RouteCollection add(String method, String uriPattern, AnyRoute route) {
        this.routes.addUserRoute(new RouteWithPattern(method, uriPattern, route));
        return this;
    }

    public WebSocketListener createWebSocketListener(WebSocketSession session, Request request, Response response) {
        Context context = this.createContext(request, response);
        return this.webSocketListenerFactory.create(session, context);
    }

    public Payload apply(Request request, Response response) throws Exception {
        Context context = this.createContext(request, response);
        if (context.uri() == null) {
            return Payload.notFound();
        }
        return this.contextToPayload.get(context.uri(), context);
    }

    private static ContextToPayload createContextToPayload(Route[] sortedRoutes, Deque<Supplier<Filter>> filters) {
        ContextToPayload payloadSupplier = (uri, context) -> {
            Payload response = Payload.notFound();
            for (Route route : sortedRoutes) {
                if (!route.matchUri(uri)) continue;
                if (route.matchMethod(context.method())) {
                    return route.apply(uri, context);
                }
                response = Payload.methodNotAllowed();
            }
            return response;
        };
        for (Supplier<Filter> filterSupplier : filters) {
            Filter filter = filterSupplier.get();
            ContextToPayload nextFilter = payloadSupplier;
            payloadSupplier = (uri, context) -> {
                if (filter.matches(uri, context)) {
                    return filter.apply(uri, context, () -> nextFilter.get(uri, context));
                }
                return nextFilter.get(uri, context);
            };
        }
        return payloadSupplier;
    }

    protected MethodAnnotationsFactory createMethodAnnotationsFactory() {
        MethodAnnotationsFactory factory = new MethodAnnotationsFactory();
        factory.registerAroundAnnotation(Roles.class, () -> (roles, context, payloadSupplier) -> this.isAuthorized((Roles)roles, context.currentUser()) ? (Payload)payloadSupplier.apply(context) : Payload.forbidden());
        factory.registerAfterAnnotation(AllowOrigin.class, () -> (origin, context, payload) -> payload.withAllowOrigin(origin.value()));
        factory.registerAfterAnnotation(AllowMethods.class, () -> (methods, context, payload) -> payload.withAllowMethods(methods.value()));
        factory.registerAfterAnnotation(AllowCredentials.class, () -> (credentials, context, payload) -> payload.withAllowCredentials(credentials.value()));
        factory.registerAfterAnnotation(AllowHeaders.class, () -> (allowedHeaders, context, payload) -> payload.withAllowHeaders(allowedHeaders.value()));
        factory.registerAfterAnnotation(ExposeHeaders.class, () -> (exposedHeaders, context, payload) -> payload.withExposeHeaders(exposedHeaders.value()));
        factory.registerAfterAnnotation(MaxAge.class, () -> (maxAge, context, payload) -> payload.withMaxAge(maxAge.value()));
        return factory;
    }

    protected boolean isAuthorized(Roles roles, User user) {
        if (roles.allMatch()) {
            return Stream.of(roles.value()).allMatch(role -> user.isInRole((String)role));
        }
        return Stream.of(roles.value()).anyMatch(role -> user.isInRole((String)role));
    }

    protected String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

