/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.net.URL;
import net.codestory.http.io.ClassPaths;
import org.webjars.WebJarAssetLocator;

public class WebJarUrlFinder {
    private final WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator();
    private final boolean useMinifiedVersions;

    public WebJarUrlFinder(boolean useMinifiedVersions) {
        this.useMinifiedVersions = useMinifiedVersions;
    }

    public URL url(String path) {
        URL urlMinified = this.getResource(WebJarUrlFinder.minified(path));
        URL urlNotMinified = this.getResource(WebJarUrlFinder.notMinified(path));
        if (this.useMinifiedVersions) {
            return urlMinified != null ? urlMinified : urlNotMinified;
        }
        return urlNotMinified != null ? urlNotMinified : urlMinified;
    }

    private URL getResource(String uri) {
        try {
            String fullPath = this.webJarAssetLocator.getFullPath(uri);
            return ClassPaths.getResource(fullPath);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String minified(String path) {
        return path.contains(".min.") ? path : path.replace(".js", ".min.js").replace(".css", ".min.css");
    }

    private static String notMinified(String path) {
        return path.replace(".min.", ".");
    }
}

