/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.forms;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Form {
    private final Map<String, String> keyValues;

    public Form(Map<String, String> keyValues) {
        this.keyValues = keyValues;
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.keyValues.forEach(action);
    }

    public Set<String> keys() {
        return this.keyValues.keySet();
    }

    public String get(String name) {
        return this.keyValues.get(name);
    }

    public String get(String name, String defaultValue) {
        String value = this.get(name);
        return value != null ? value : defaultValue;
    }

    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.get(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long defaultValue) {
        String value = this.get(name);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float defaultValue) {
        String value = this.get(name);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        String value = this.get(name);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }
}

