/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.codestory.http.internal.Unwrappable;

public interface Query
extends Unwrappable {
    public Collection<String> keys();

    public Iterable<String> all(String var1);

    default public String get(String name) {
        Iterator<String> values = this.all(name).iterator();
        return values.hasNext() ? values.next() : null;
    }

    default public Map<String, String> keyValues() {
        return this.keys().stream().collect(Collectors.toMap(key -> key, key -> this.get((String)key)));
    }

    default public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    default public int getInteger(String name, int defaultValue) {
        String value = this.get(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    default public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    default public long getLong(String name, long defaultValue) {
        String value = this.get(name);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    default public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    default public float getFloat(String name, float defaultValue) {
        String value = this.get(name);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    default public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    default public double getDouble(String name, double defaultValue) {
        String value = this.get(name);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    default public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    default public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }
}

