/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.templating.Site;

public class PreCompile {
    private final CompilerFacade compilers;
    private final Site site;

    public PreCompile(Env env) {
        Resources resources = new Resources(env);
        this.compilers = new CompilerFacade(env, resources);
        this.site = new Site(env, resources);
    }

    public static void main(String[] args) {
        Env env = Env.prod();
        String destinationFolder = args.length > 0 ? args[0] : env.appFolder();
        PreCompile preCompile = new PreCompile(env);
        preCompile.run(destinationFolder);
    }

    public void run(String destinationFolder) {
        this.site.getResourceList().forEach(path -> this.preCompile((String)path, destinationFolder));
    }

    protected void preCompile(String path, String destinationFolder) {
        String extension = Strings.extension(path);
        if (!this.compilers.canCompile(extension)) {
            return;
        }
        Path fromPath = Paths.get(path, new String[0]);
        Path toPath = this.toPath(path, extension, destinationFolder);
        System.out.println("Pre-compile [" + fromPath + "] to [" + toPath + "]");
        try {
            byte[] bytes = this.compile(fromPath);
            this.write(bytes, toPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pre-compile " + path, e);
        }
    }

    protected Path toPath(String path, String extension, String destinationFolder) {
        String compiledExtension = this.compilers.compiledExtension(extension);
        String newName = Strings.replaceLast(path, extension, compiledExtension);
        return Paths.get(destinationFolder, newName);
    }

    protected byte[] compile(Path fromPath) throws IOException {
        return this.compilers.compile(fromPath).toBytes();
    }

    protected void write(byte[] bytes, Path toPath) throws IOException {
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        Files.write(toPath, bytes, new OpenOption[0]);
    }
}

