/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.mixed;

import net.codestory.http.Context;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.filters.auth.CookieAuthFilter;
import net.codestory.http.filters.basic.BasicAuthFilter;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.SessionIdStore;
import net.codestory.http.security.Users;

public class MixedAuthFilter
implements Filter {
    private final Filter cookieAuthFilter;
    private final Filter basicAuthFilter;

    public MixedAuthFilter(String uriPrefix, String realm, Users users, SessionIdStore sessionIdStore) {
        this.cookieAuthFilter = new CookieAuthFilter(uriPrefix, users, sessionIdStore);
        this.basicAuthFilter = new BasicAuthFilter(uriPrefix, realm, users);
    }

    public MixedAuthFilter(String uriPrefix, String realm, Users users, SessionIdStore sessionIdStore, String ignoreExtension, String ... moreIgnoreExtensions) {
        this.cookieAuthFilter = new CookieAuthFilter(uriPrefix, users, sessionIdStore, ignoreExtension, moreIgnoreExtensions);
        this.basicAuthFilter = new BasicAuthFilter(uriPrefix, realm, users);
    }

    @Override
    public boolean matches(String uri, Context context) {
        return this.authFilter(context).matches(uri, context);
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        return this.authFilter(context).apply(uri, context, nextFilter);
    }

    private Filter authFilter(Context context) {
        return context.header("Authorization") == null ? this.cookieAuthFilter : this.basicAuthFilter;
    }
}

