/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Options;
import java.util.function.Function;
import net.codestory.http.misc.Cache;
import net.codestory.http.templating.helpers.HelperTools;
import org.webjars.WebJarAssetLocator;

public class WebjarHelperSource {
    private final WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator();
    private final Function<String, String> fullPathForUri;

    public WebjarHelperSource(boolean prodMode) {
        this.fullPathForUri = prodMode ? new Cache<String, String>(uri -> this.fullPathForUri((String)uri)) : uri -> this.fullPathForUri((String)uri);
    }

    public CharSequence webjar(Object context, Options options) {
        String attributes = HelperTools.hashAsString(options);
        return HelperTools.toString(context, value -> this.single_webjar(value, attributes));
    }

    private String single_webjar(Object value, String attributes) {
        String fullPath = this.fullPathForUri.apply(value.toString());
        return this.tag(fullPath, attributes);
    }

    private String fullPathForUri(String uri) {
        try {
            return this.webJarAssetLocator.getFullPath(uri).replace("META-INF/resources/webjars/", "/webjars/");
        }
        catch (IllegalArgumentException e) {
            return uri;
        }
    }

    private String tag(String fullPath, String attributes) {
        if (fullPath.endsWith(".css")) {
            return "<link rel=\"stylesheet\" href=\"" + fullPath + "\"" + attributes + ">";
        }
        return "<script src=\"" + fullPath + "\"" + attributes + "></script>";
    }
}

