/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.payload.Payload;

public class MethodAnnotations {
    private final List<BiFunction<Context, Function<Context, Payload>, Payload>> operations = new ArrayList<BiFunction<Context, Function<Context, Payload>, Payload>>();

    MethodAnnotations() {
    }

    void addAroundOperation(BiFunction<Context, Function<Context, Payload>, Payload> operation) {
        this.operations.add(operation);
    }

    void addAfterOperation(BiFunction<Context, Payload, Payload> operation) {
        this.operations.add((context, payloadSupplier) -> (Payload)operation.apply((Context)context, (Payload)payloadSupplier.apply(context)));
    }

    public Payload apply(Context context, Function<Context, Payload> payloadSupplier) {
        Function<Context, Payload> current = payloadSupplier;
        for (BiFunction<Context, Function<Context, Payload>, Payload> operation : this.operations) {
            current = ctx -> (Payload)operation.apply((Context)ctx, payloadSupplier);
        }
        return current.apply(context);
    }
}

