/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.net.URL;
import net.codestory.http.io.ClassPaths;

public class WebJarUrlFinder {
    private final boolean useMinifiedVersions;

    public WebJarUrlFinder(boolean useMinifiedVersions) {
        this.useMinifiedVersions = useMinifiedVersions;
    }

    public URL url(String path) {
        URL urlMinified = WebJarUrlFinder.getResource(WebJarUrlFinder.minified(path));
        URL urlNotMinified = WebJarUrlFinder.getResource(WebJarUrlFinder.notMinified(path));
        if (this.useMinifiedVersions) {
            return urlMinified != null ? urlMinified : urlNotMinified;
        }
        return urlNotMinified != null ? urlNotMinified : urlMinified;
    }

    private static URL getResource(String uri) {
        return ClassPaths.getResource("META-INF/resources" + uri);
    }

    private static String minified(String path) {
        return path.contains(".min.") ? path : path.replace(".js", ".min.js").replace(".css", ".min.css");
    }

    private static String notMinified(String path) {
        return path.replace(".min.", ".");
    }
}

