/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.cors;

import java.net.URI;
import java.net.URISyntaxException;
import net.codestory.http.Request;
import net.codestory.http.cors.CORSRequestType;
import net.codestory.http.types.ContentTypes;

public abstract class CORSHelper {
    private CORSHelper() {
    }

    public static CORSRequestType corsRequestType(Request request) {
        String origin = request.header("Origin");
        if (origin == null) {
            return CORSRequestType.NOT_CORS;
        }
        if (CORSHelper.isInvalidOrigin(origin)) {
            return CORSRequestType.INVALID_CORS;
        }
        switch (request.method()) {
            case "OPTIONS": {
                String accessControl = request.header("Access-Control-Request-Method");
                if (accessControl == null) {
                    return CORSRequestType.ACTUAL;
                }
                return accessControl.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.PRE_FLIGHT;
            }
            case "GET": 
            case "HEAD": {
                return CORSRequestType.SIMPLE;
            }
            case "POST": {
                String contentType = request.contentType();
                if (contentType == null) {
                    return CORSRequestType.INVALID_CORS;
                }
                return ContentTypes.SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(contentType.toLowerCase().trim()) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
            }
            case "PUT": 
            case "DELETE": 
            case "TRACE": 
            case "CONNECT": {
                return CORSRequestType.ACTUAL;
            }
        }
        return CORSRequestType.INVALID_CORS;
    }

    private static boolean isInvalidOrigin(String origin) {
        if (origin.isEmpty() || origin.contains("%")) {
            return true;
        }
        try {
            return new URI(origin).getScheme() == null;
        }
        catch (URISyntaxException e) {
            return true;
        }
    }
}

