/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.markdown.MarkdownCompiler;
import net.codestory.http.misc.Env;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.TemplatingEngine;
import net.codestory.http.templating.helpers.AssetsHelperSource;
import net.codestory.http.templating.helpers.EachReverseHelperSource;
import net.codestory.http.templating.helpers.EachValueHelperSource;
import net.codestory.http.templating.helpers.GoogleAnalyticsHelper;
import net.codestory.http.templating.helpers.LiveReloadHelper;
import net.codestory.http.templating.helpers.WebjarHelperSource;

public class HandlebarsCompiler
implements TemplatingEngine {
    private final Handlebars handlebars;
    private final List<ValueResolver> resolvers;

    public HandlebarsCompiler(Env env, Resources resources, CompilerFacade compilers, MarkdownCompiler markdownCompiler) {
        this.handlebars = HandlebarsCompiler.handlebars(env, resources, compilers, markdownCompiler);
        this.resolvers = new ArrayList<ValueResolver>(Arrays.asList(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE}));
    }

    @Override
    public boolean supports(Path path) {
        switch (Strings.extension(path.toString())) {
            case ".txt": 
            case ".md": 
            case ".markdown": 
            case ".html": 
            case ".xml": 
            case ".json": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String compile(String template, Map<String, Object> variables) throws IOException {
        return this.handlebars.compileInline(template).apply(this.context(variables));
    }

    private static Handlebars handlebars(Env env, final Resources resources, CompilerFacade compilers, final MarkdownCompiler markdownCompiler) {
        return new Handlebars().startDelimiter("[[").endDelimiter("]]").registerHelpers((Object)new EachReverseHelperSource()).registerHelpers((Object)new EachValueHelperSource()).registerHelpers((Object)new GoogleAnalyticsHelper()).registerHelpers((Object)new LiveReloadHelper(env.prodMode())).registerHelpers((Object)new AssetsHelperSource(env.prodMode(), resources, compilers)).registerHelpers((Object)new WebjarHelperSource(env.prodMode())).registerHelpers(StringHelpers.class).with((TemplateCache)new ConcurrentMapTemplateCache()).with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) throws IOException {
                Path include = resources.findExistingPath("_includes/" + location);
                if (include == null) {
                    throw new IOException("Template not found " + location);
                }
                String body = resources.sourceFile(include).getSource();
                if (MarkdownCompiler.supports(include)) {
                    body = markdownCompiler.compile(body);
                }
                return new StringTemplateSource(location, body);
            }
        }});
    }

    private Context context(Map<String, ?> variables) {
        return Context.newBuilder(null).resolver((ValueResolver[])this.resolvers.stream().toArray(ValueResolver[]::new)).combine(variables).build();
    }

    public void configure(Consumer<Handlebars> action) {
        action.accept(this.handlebars);
    }

    public void addResolver(ValueResolver resolver) {
        this.resolvers.add(resolver);
    }
}

