/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Function;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.misc.Cache;
import net.codestory.http.misc.Sha1;
import net.codestory.http.templating.helpers.HelperTools;

public class AssetsHelperSource {
    private final Resources resources;
    private final CompilerFacade compilers;
    private final Function<String, String> urlSupplier;

    public AssetsHelperSource(boolean prodMode, Resources resources, CompilerFacade compilers) {
        this.resources = resources;
        this.compilers = compilers;
        this.urlSupplier = prodMode ? new Cache<String, String>(path -> this.uriWithSha1((String)path)) : path -> this.uriWithSha1((String)path);
    }

    public CharSequence script(Object context, Options options) {
        String attributes = HelperTools.hashAsString(options);
        return HelperTools.toString(context, value -> this.singleScript(value.toString(), attributes));
    }

    public CharSequence css(Object context, Options options) {
        String attributes = HelperTools.hashAsString(options);
        return HelperTools.toString(context, value -> this.singleCss(value.toString(), attributes));
    }

    private String uriWithSha1(String uri) {
        try {
            Path path = this.resources.findExistingPath(uri);
            if (path != null && this.resources.isPublic(path)) {
                return uri + '?' + Sha1.of(this.resources.readBytes(path));
            }
            Path sourcePath = this.compilers.findPublicSourceFor(uri);
            if (sourcePath != null) {
                return uri + '?' + Sha1.of(this.resources.readBytes(sourcePath));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to compute sha1 for: " + uri, e);
        }
        return uri;
    }

    private CharSequence singleScript(String path, String attributes) {
        String uri = AssetsHelperSource.addExtensionIfMissing(path, ".js");
        return "<script src=\"" + this.urlSupplier.apply(uri) + "\"" + attributes + "></script>";
    }

    private CharSequence singleCss(String path, String attributes) {
        String uri = AssetsHelperSource.addExtensionIfMissing(path, ".css");
        return "<link rel=\"stylesheet\" href=\"" + this.urlSupplier.apply(uri) + "\"" + attributes + ">";
    }

    private static String addExtensionIfMissing(String uri, String extension) {
        return uri.endsWith(extension) ? uri : uri + extension;
    }
}

