/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.PathSource;

public class LessSourceMapCompiler
implements Compiler {
    @Override
    public String compile(Path path, String source) {
        try {
            Path sourcePath = Paths.get(path.toString().replace(".map", ""), new String[0]);
            String sourceMap = new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(sourcePath, source)).getSourceMap();
            String sourcePathAsString = sourcePath.toString();
            sourceMap = sourceMap.replaceAll(".css", ".less").replaceAll(sourcePathAsString, sourcePathAsString.replace(".less", ".less.source"));
            return sourceMap;
        }
        catch (Less4jException e) {
            String message = LessSourceMapCompiler.cleanMessage(path, e.getMessage());
            throw new CompilerException(message);
        }
    }

    private static String cleanMessage(Path path, String message) {
        return "Unable to compile less " + path + ": " + message.replace("Could not compile less. ", "");
    }
}

