/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.util.Collections;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.NashornCompiler;
import net.codestory.http.compilers.SourceFile;

public class CoffeeCompiler
implements Compiler {
    private final NashornCompiler nashornCompiler = NashornCompiler.get("META-INF/resources/webjars/coffee-script/1.9.1/coffee-script.min.js", "coffee-script/toJs.js");
    private final boolean sourceMaps;

    public CoffeeCompiler(boolean prodMode) {
        this.sourceMaps = !prodMode;
    }

    @Override
    public String compile(SourceFile sourceFile) {
        Map<String, Object> options = Collections.singletonMap("__literate", sourceFile.hasExtension(".litcoffee"));
        String filename = sourceFile.getFileName();
        String sourceName = filename + ".source";
        String source = sourceFile.getSource();
        String javascript = this.nashornCompiler.compile(filename, sourceName, source, options);
        if (this.sourceMaps) {
            return CoffeeCompiler.addSourceMapping(javascript, sourceFile);
        }
        return javascript;
    }

    private static String addSourceMapping(String javascript, SourceFile sourceFile) {
        return javascript + "\n//# sourceMappingURL=" + sourceFile.getFileName() + ".map";
    }
}

