/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.annotations.ApplyAfterAnnotation;
import net.codestory.http.annotations.ApplyAroundAnnotation;
import net.codestory.http.annotations.MethodAnnotations;
import net.codestory.http.payload.Payload;

public class MethodAnnotationsFactory {
    private final Map<Class<? extends Annotation>, ApplyAroundAnnotation<? extends Annotation>> aroundAnnotations = new LinkedHashMap<Class<? extends Annotation>, ApplyAroundAnnotation<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, ApplyAfterAnnotation<? extends Annotation>> afterAnnotations = new LinkedHashMap<Class<? extends Annotation>, ApplyAfterAnnotation<? extends Annotation>>();

    public <T extends Annotation> void registerAroundAnnotation(Class<T> type, ApplyAroundAnnotation<T> apply) {
        this.aroundAnnotations.put(type, apply);
    }

    public <T extends Annotation> void registerAfterAnnotation(Class<T> type, ApplyAfterAnnotation<T> apply) {
        this.afterAnnotations.put(type, apply);
    }

    public MethodAnnotations forMethod(Method method) {
        MethodAnnotations methodAnnotations = new MethodAnnotations();
        this.aroundAnnotations.forEach((annotationType, apply) -> this.addAroundOperationIfNecessary((Class)annotationType, (ApplyAroundAnnotation<? extends Annotation>)apply, method, methodAnnotations));
        this.afterAnnotations.forEach((annotationType, apply) -> this.addAfterOperationIfNecessary((Class)annotationType, (ApplyAfterAnnotation<? extends Annotation>)apply, method, methodAnnotations));
        return methodAnnotations;
    }

    private <T extends Annotation> void addAroundOperationIfNecessary(Class<T> annotationType, ApplyAroundAnnotation<? extends Annotation> apply, Method method, MethodAnnotations methodAnnotations) {
        Object annotation = this.findAnnotationOnMethodOrClass(annotationType, method);
        if (annotation != null) {
            methodAnnotations.addAroundOperation((context, payloadSupplier) -> apply.apply((Annotation)annotation, (Context)context, (Function<Context, Payload>)payloadSupplier));
        }
    }

    private <T extends Annotation> void addAfterOperationIfNecessary(Class<T> annotationType, ApplyAfterAnnotation<? extends Annotation> apply, Method method, MethodAnnotations methodAnnotations) {
        Object annotation = this.findAnnotationOnMethodOrClass(annotationType, method);
        if (annotation != null) {
            methodAnnotations.addAfterOperation((context, payload) -> apply.apply((Annotation)annotation, (Context)context, (Payload)payload));
        }
    }

    private <T extends Annotation> T findAnnotationOnMethodOrClass(Class<T> annotationType, Method method) {
        T annotation = method.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        annotation = method.getDeclaringClass().getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }
}

