/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.cors.CORSHelper;
import net.codestory.http.cors.CORSRequestType;
import net.codestory.http.internal.Unwrappable;
import net.codestory.http.io.InputStreams;

public interface Request
extends Unwrappable {
    public String uri();

    public String method();

    public String content() throws IOException;

    public String contentType();

    public List<String> headerNames();

    public List<String> headers(String var1);

    public String header(String var1);

    public InputStream inputStream() throws IOException;

    public InetSocketAddress clientAddress();

    public boolean isSecure();

    public Cookies cookies();

    public Query query();

    public List<Part> parts();

    default public boolean isUrlEncodedForm() {
        String contentType = this.header("Content-Type");
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }

    default public byte[] contentAsBytes() throws IOException {
        return InputStreams.readBytes(this.inputStream());
    }

    default public <T> T contentAs(Class<T> type) throws IOException {
        if (this.isUrlEncodedForm()) {
            return TypeConvert.convertValue(this.query().keyValues(), type);
        }
        return TypeConvert.fromJson(this.content(), type);
    }

    default public <T> T contentAs(Type type) throws IOException {
        if (this.isUrlEncodedForm()) {
            return (T)TypeConvert.convertValue(this.query().keyValues(), type);
        }
        return TypeConvert.fromJson(this.content(), type);
    }

    default public <T> T contentAs(TypeReference<T> type) throws IOException {
        if (this.isUrlEncodedForm()) {
            return TypeConvert.convertValue(this.query().keyValues(), type);
        }
        return TypeConvert.fromJson(this.content(), type);
    }

    default public String header(String name, String defaultValue) {
        return Optional.ofNullable(this.header(name)).orElse(defaultValue);
    }

    default public Map<String, List<String>> headers() {
        return this.headerNames().stream().collect(Collectors.toMap(name -> name, name -> this.headers((String)name)));
    }

    default public String clientAddressForwarded() {
        String forwarded = this.header("X-Forwarded-For");
        return forwarded != null ? forwarded : this.clientAddress().toString();
    }

    default public CORSRequestType corsRequestType() {
        return CORSHelper.corsRequestType(this);
    }

    default public boolean isCORS() {
        return this.corsRequestType().isCORS();
    }

    default public boolean isPreflight() {
        return this.corsRequestType().isPreflight();
    }
}

