/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.types;

import java.util.Arrays;
import java.util.List;

public class ContentTypes {
    public static final List<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");

    private ContentTypes() {
    }

    private static String extension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex <= 0 ? "" : filename.substring(dotIndex);
    }

    public static String get(String filename) {
        switch (ContentTypes.extension(filename)) {
            case ".html": 
            case ".md": 
            case ".markdown": {
                return "text/html;charset=UTF-8";
            }
            case ".xml": {
                return "application/xml;charset=UTF-8";
            }
            case ".json": {
                return "application/json;charset=UTF-8";
            }
            case ".css": 
            case ".less": {
                return "text/css;charset=UTF-8";
            }
            case ".js": 
            case ".coffee": 
            case ".litcoffee": {
                return "application/javascript;charset=UTF-8";
            }
            case ".zip": {
                return "application/zip";
            }
            case ".gz": {
                return "application/gzip";
            }
            case ".pdf": {
                return "application/pdf";
            }
            case ".gif": {
                return "image/gif";
            }
            case ".jpeg": 
            case ".jpg": {
                return "image/jpeg";
            }
            case ".png": {
                return "image/png";
            }
            case ".svg": {
                return "image/svg+xml";
            }
            case ".eot": {
                return "application/vnd.ms-fontobject";
            }
            case ".ttf": {
                return "application/x-font-ttf";
            }
            case ".woff": {
                return "application/x-font-woff";
            }
            case ".ico": {
                return "image/x-icon";
            }
        }
        return "text/plain;charset=UTF-8";
    }

    public static boolean supportsTemplating(String filename) {
        switch (ContentTypes.extension(filename)) {
            case ".txt": 
            case ".md": 
            case ".markdown": 
            case ".html": 
            case ".xml": 
            case ".json": {
                return true;
            }
        }
        return false;
    }
}

