/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.io.Resources;
import net.codestory.http.markdown.MarkdownCompiler;
import net.codestory.http.templating.TemplatingEngine;
import net.codestory.http.templating.yaml.YamlFrontMatter;

public class ViewCompiler {
    private final Resources resources;
    private final TemplatingEngine templatingEngine;
    private final MarkdownCompiler markdownCompiler;

    public ViewCompiler(Resources resources, TemplatingEngine templatingEngine, MarkdownCompiler markdownCompiler) {
        this.resources = resources;
        this.templatingEngine = templatingEngine;
        this.markdownCompiler = markdownCompiler;
    }

    public String render(String uri, Map<String, ?> keyValues) {
        Path path = this.resources.findExistingPath(uri);
        if (path == null) {
            throw new IllegalArgumentException("Template not found " + uri);
        }
        try {
            String layout;
            YamlFrontMatter yamlFrontMatter = YamlFrontMatter.parse(this.resources.sourceFile(path));
            String content = yamlFrontMatter.getContent();
            Map<String, Object> variables = yamlFrontMatter.getVariables();
            Map<String, Object> allKeyValues = ViewCompiler.merge(variables, keyValues);
            String body = this.templatingEngine.compile(content, allKeyValues);
            if (MarkdownCompiler.supports(path)) {
                body = this.markdownCompiler.compile(body);
            }
            if ((layout = (String)variables.get("layout")) == null) {
                return body;
            }
            String layoutContent = this.render("_layouts/" + layout, allKeyValues);
            return layoutContent.replace("[[body]]", body);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    private static Map<String, Object> merge(Map<String, ?> first, Map<String, ?> second) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(first);
        merged.putAll(second);
        merged.put("body", "[[body]]");
        return merged;
    }
}

