/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.markdown.MarkdownCompiler;
import net.codestory.http.misc.Env;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.ViewCompiler;
import net.codestory.http.templating.YamlFrontMatter;

public class HandlebarsViewCompiler
implements ViewCompiler {
    private final Resources resources;
    private final HandlebarsCompiler handlebars;

    public HandlebarsViewCompiler(Env env, Resources resources, CompilerFacade compilers) {
        this.resources = resources;
        this.handlebars = new HandlebarsCompiler(env, resources, compilers);
    }

    @Override
    public void configureHandlebars(Consumer<Handlebars> action) {
        this.handlebars.configure(action);
    }

    @Override
    public void addHandlebarsResolver(ValueResolver resolver) {
        this.handlebars.addResolver(resolver);
    }

    @Override
    public String render(String uri, Map<String, ?> keyValues) {
        Path path = this.resources.findExistingPath(uri);
        if (path == null) {
            throw new IllegalArgumentException("Template not found " + uri);
        }
        try {
            String layout;
            YamlFrontMatter yamlFrontMatter = YamlFrontMatter.parse(this.resources.sourceFile(path));
            String content = yamlFrontMatter.getContent();
            Map<String, Object> variables = yamlFrontMatter.getVariables();
            Map<String, Object> allKeyValues = HandlebarsViewCompiler.merge(variables, keyValues);
            String body = this.handlebars.compile(content, allKeyValues);
            if (MarkdownCompiler.supports(path)) {
                body = MarkdownCompiler.INSTANCE.compile(body);
            }
            if ((layout = (String)variables.get("layout")) == null) {
                return body;
            }
            String layoutContent = this.render("_layouts/" + layout, allKeyValues);
            return layoutContent.replace("[[body]]", body);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    private static Map<String, Object> merge(Map<String, ?> first, Map<String, ?> second) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(first);
        merged.putAll(second);
        merged.put("body", "[[body]]");
        return merged;
    }
}

