/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.codestory.http.Context;
import net.codestory.http.annotations.ApplyByPassAnnotation;
import net.codestory.http.annotations.ApplyEnrichAnnotation;
import net.codestory.http.annotations.MethodAnnotations;
import net.codestory.http.payload.Payload;

public class MethodAnnotationsFactory {
    private final Map<Class<? extends Annotation>, ApplyByPassAnnotation<? extends Annotation>> byPassAnnotations = new LinkedHashMap<Class<? extends Annotation>, ApplyByPassAnnotation<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, ApplyEnrichAnnotation<? extends Annotation>> enrichAnnotations = new LinkedHashMap<Class<? extends Annotation>, ApplyEnrichAnnotation<? extends Annotation>>();

    public <T extends Annotation> void registerByPassAnnotation(Class<T> type, ApplyByPassAnnotation<T> apply) {
        this.byPassAnnotations.put(type, apply);
    }

    public <T extends Annotation> void registerEnrichAnnotation(Class<T> type, ApplyEnrichAnnotation<T> apply) {
        this.enrichAnnotations.put(type, apply);
    }

    public MethodAnnotations forMethod(Method method) {
        MethodAnnotations methodAnnotations = new MethodAnnotations();
        this.byPassAnnotations.forEach((annotationType, apply) -> this.addByPassOperationIdNecessary((Class)annotationType, (ApplyByPassAnnotation<? extends Annotation>)apply, method, methodAnnotations));
        this.enrichAnnotations.forEach((annotationType, apply) -> this.addEnrichOperationIdNecessary((Class)annotationType, (ApplyEnrichAnnotation<? extends Annotation>)apply, method, methodAnnotations));
        return methodAnnotations;
    }

    private <T extends Annotation> void addByPassOperationIdNecessary(Class<T> annotationType, ApplyByPassAnnotation<? extends Annotation> apply, Method method, MethodAnnotations methodAnnotations) {
        Object annotation = this.findAnnotationOnMethodOrClass(annotationType, method);
        if (annotation != null) {
            methodAnnotations.addByPassOperation(context -> apply.apply((Context)context, (Annotation)annotation));
        }
    }

    private <T extends Annotation> void addEnrichOperationIdNecessary(Class<T> annotationType, ApplyEnrichAnnotation<? extends Annotation> apply, Method method, MethodAnnotations methodAnnotations) {
        Object annotation = this.findAnnotationOnMethodOrClass(annotationType, method);
        if (annotation != null) {
            methodAnnotations.addEnrichOperation(context -> apply.apply((Payload)context, (Annotation)annotation));
        }
    }

    private <T extends Annotation> T findAnnotationOnMethodOrClass(Class<T> annotationType, Method method) {
        T annotation = method.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        annotation = method.getDeclaringClass().getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }
}

