/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.payload.Payload;

public class MethodAnnotations {
    private final List<Function<Context, Payload>> byPassOperations = new ArrayList<Function<Context, Payload>>();
    private final List<Function<Payload, Payload>> enrichOperations = new ArrayList<Function<Payload, Payload>>();

    MethodAnnotations() {
    }

    void addByPassOperation(Function<Context, Payload> operation) {
        this.byPassOperations.add(operation);
    }

    void addEnrichOperation(Function<Payload, Payload> operation) {
        this.enrichOperations.add(operation);
    }

    public Payload byPass(Context context) {
        for (Function<Context, Payload> operation : this.byPassOperations) {
            Payload payload = operation.apply(context);
            if (payload == null) continue;
            return payload;
        }
        return null;
    }

    public Payload enrich(Payload payload) {
        for (Function<Payload, Payload> operation : this.enrichOperations) {
            payload = operation.apply(payload);
        }
        return payload;
    }
}

