/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.LessSource;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.Resources;

class PathSource
extends LessSource {
    private final Resources resources;
    private final SourceFile sourceFile;

    PathSource(Resources resources, SourceFile sourceFile) {
        this.resources = resources;
        this.sourceFile = sourceFile;
    }

    public LessSource relativeSource(String filename) throws LessSource.CannotReadFile, LessSource.FileNotFound {
        if (filename.startsWith("/webjars/")) {
            URL webjarResource = ClassPaths.getResource("META-INF/resources" + filename);
            if (webjarResource == null) {
                throw new LessSource.FileNotFound();
            }
            return new LessSource.URLSource(webjarResource);
        }
        Path relativePath = Paths.get(filename, new String[0]);
        if (!this.resources.exists(relativePath)) {
            throw new LessSource.FileNotFound();
        }
        try {
            return new PathSource(this.resources, this.resources.sourceFile(relativePath));
        }
        catch (IOException e) {
            throw new LessSource.CannotReadFile();
        }
    }

    public String getName() {
        return this.sourceFile.getFileName();
    }

    public String getContent() {
        return this.sourceFile.getSource();
    }

    public byte[] getBytes() {
        return this.sourceFile.getSource().getBytes();
    }
}

