/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.Configuration;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.FolderChangeListener;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;

class ReloadingRoutesProvider
implements RoutesProvider {
    private final Env env;
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private RouteCollection routes;
    private FolderChangeListener folderChangeListener;

    ReloadingRoutesProvider(Env env, Configuration configuration) {
        this.env = env;
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            Logs.reloadingConfiguration();
            this.routes = new RouteCollection(this.env);
            try {
                this.routes.configure(this.configuration);
            }
            catch (Exception e) {
                Logs.unableToConfigureRoutes(e);
            }
            this.dirty.set(false);
            if (this.folderChangeListener != null) {
                this.env.folderWatcher().removeListener(this.folderChangeListener);
            }
            this.folderChangeListener = () -> this.dirty.set(true);
            this.env.folderWatcher().addListener(this.folderChangeListener);
        }
        this.env.folderWatcher().ensureStarted();
        return this.routes;
    }
}

