/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.Strings;

public class ClasspathScanner {
    public Set<String> getResources(Path root) {
        String prefix = root.toString();
        return this.listPaths(prefix, path -> !path.endsWith(".class"));
    }

    public Set<Class<?>> getTypesAnnotatedWith(String packageToScan, Class<? extends Annotation> annotation) {
        String prefix = packageToScan.replace('.', '/');
        LinkedHashSet classes = new LinkedHashSet();
        for (String classFile : this.listPaths(prefix, path -> path.endsWith(".class"))) {
            String className = Strings.substringBeforeLast(classFile.replace('/', '.'), ".class");
            try {
                Class<?> type = Class.forName(className);
                if (!type.isAnnotationPresent(annotation)) continue;
                classes.add(type);
            }
            catch (Exception exception) {}
        }
        return classes;
    }

    public Set<String> listPaths(String prefix, Predicate<String> filter) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (URL url : ClasspathScanner.urls(prefix)) {
            for (String rawPath : ClassPaths.fromURL(url)) {
                String path = rawPath.replace('\\', '/');
                if (!path.startsWith(prefix) || !filter.test(path)) continue;
                paths.add(path);
            }
        }
        return paths;
    }

    private static Set<URL> urls(String name) {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> urls = ClasspathScanner.class.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String externalForm = url.toExternalForm().replace('\\', '/');
                int index = externalForm.lastIndexOf(name);
                if (index != -1) {
                    result.add(new URL(externalForm.substring(0, index)));
                    continue;
                }
                result.add(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

