/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.codestory.http.Context;
import net.codestory.http.annotations.AllowCredentials;
import net.codestory.http.annotations.AllowHeaders;
import net.codestory.http.annotations.AllowMethods;
import net.codestory.http.annotations.AllowOrigin;
import net.codestory.http.annotations.ExposeHeaders;
import net.codestory.http.annotations.MaxAge;
import net.codestory.http.annotations.Produces;
import net.codestory.http.annotations.Roles;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.security.User;

class ReflectionRoute
implements AnyRoute {
    private final Supplier<Object> resource;
    private final Method method;

    ReflectionRoute(Supplier<Object> resource, Method method) {
        this.resource = resource;
        this.method = method;
    }

    @Override
    public Object body(Context context, String[] pathParameters) {
        if (!this.isAuthorized(context.currentUser())) {
            return Payload.forbidden();
        }
        try {
            Object target = this.resource.get();
            Object[] arguments = ReflectionRoute.convert(context, pathParameters, this.method.getGenericParameterTypes());
            Object response = ReflectionRoute.invoke(target, this.method, arguments);
            Object body = ReflectionRoute.emptyIfNull(response);
            String contentType = ReflectionRoute.findContentType(this.method);
            Payload payload = new Payload(contentType, body);
            this.setCorsHeaders(payload);
            return payload;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to apply route", e);
        }
    }

    private boolean isAuthorized(User user) {
        Roles roles = this.method.getDeclaredAnnotation(Roles.class);
        if (roles == null) {
            return true;
        }
        if (roles.allMatch()) {
            return Stream.of(roles.value()).allMatch(role -> user.isInRole((String)role));
        }
        return Stream.of(roles.value()).anyMatch(role -> user.isInRole((String)role));
    }

    private void setCorsHeaders(Payload finalPayload) {
        MaxAge maxAge;
        ExposeHeaders exposedHeaders;
        AllowHeaders allowedHeaders;
        AllowCredentials credentials;
        AllowMethods methods;
        AllowOrigin origin = this.method.getDeclaredAnnotation(AllowOrigin.class);
        if (origin != null) {
            finalPayload.withAllowOrigin(origin.value());
        }
        if ((methods = this.method.getDeclaredAnnotation(AllowMethods.class)) != null) {
            finalPayload.withAllowMethods(methods.value());
        }
        if ((credentials = this.method.getDeclaredAnnotation(AllowCredentials.class)) != null) {
            finalPayload.withAllowCredentials(credentials.value());
        }
        if ((allowedHeaders = this.method.getDeclaredAnnotation(AllowHeaders.class)) != null) {
            finalPayload.withAllowHeaders(allowedHeaders.value());
        }
        if ((exposedHeaders = this.method.getDeclaredAnnotation(ExposeHeaders.class)) != null) {
            finalPayload.withExposeHeaders(exposedHeaders.value());
        }
        if ((maxAge = this.method.getDeclaredAnnotation(MaxAge.class)) != null) {
            finalPayload.withMaxAge(maxAge.value());
        }
    }

    static Object[] convert(Context context, String[] pathParameters, Type ... types) throws IOException {
        int i;
        Object[] converted = new Object[types.length];
        for (i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convertValue((Object)pathParameters[i], types[i]);
        }
        for (i = pathParameters.length; i < converted.length; ++i) {
            converted[i] = context.extract(types[i]);
        }
        return converted;
    }

    private static Object invoke(Object target, Method method, Object[] arguments) throws Throwable {
        try {
            method.setAccessible(true);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object emptyIfNull(Object payload) {
        return payload == null ? "" : payload;
    }

    private static String findContentType(Method method) {
        Produces annotation = method.getAnnotation(Produces.class);
        return annotation == null ? null : annotation.value();
    }
}

