/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Cache<K, V>
implements Function<K, V> {
    private final Function<K, V> delegate;
    private final Map<K, V> keyValues;

    public Cache(Function<K, V> delegate) {
        this.delegate = delegate;
        this.keyValues = new ConcurrentHashMap();
    }

    @Override
    public V apply(K key) {
        return this.keyValues.computeIfAbsent(key, this.delegate);
    }
}

