/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.twitter;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.filters.twitter.AuthenticationException;
import net.codestory.http.filters.twitter.Authenticator;
import net.codestory.http.filters.twitter.User;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class TwitterAuthenticator
implements Authenticator {
    private final TwitterFactory twitterFactory;
    private final Map<String, RequestToken> oauthRequestByToken;

    public TwitterAuthenticator(TwitterFactory twitterFactory) {
        this.twitterFactory = twitterFactory;
        this.oauthRequestByToken = new HashMap<String, RequestToken>();
    }

    @Override
    public URI getAuthenticateURI(String callbackUri) {
        Twitter twitter = this.twitterFactory.getInstance();
        try {
            RequestToken requestToken = twitter.getOAuthRequestToken(callbackUri);
            this.oauthRequestByToken.put(requestToken.getToken(), requestToken);
            return URI.create(requestToken.getAuthenticationURL());
        }
        catch (TwitterException e) {
            throw new AuthenticationException(e);
        }
    }

    @Override
    public User authenticate(String oauthToken, String oauthVerifier) {
        Twitter twitter = this.twitterFactory.getInstance();
        try {
            AccessToken accessToken = twitter.getOAuthAccessToken(this.oauthRequestByToken.remove(oauthToken), oauthVerifier);
            twitter4j.User user = twitter.users().showUser(accessToken.getUserId());
            return new User(accessToken.getUserId(), accessToken.getScreenName(), accessToken.getToken(), accessToken.getTokenSecret(), user.getBiggerProfileImageURL());
        }
        catch (TwitterException e) {
            throw new AuthenticationException(e);
        }
    }
}

