/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import java.util.function.Function;
import net.codestory.http.misc.Cache;
import net.codestory.http.templating.helpers.HelperTools;
import org.webjars.WebJarAssetLocator;

public class WebjarHelperSource {
    private final WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator();
    private final Function<String, String> webJarForUri;

    public WebjarHelperSource(boolean prodMode) {
        this.webJarForUri = prodMode ? new Cache<String, String>(uri -> this.webjar((String)uri)) : uri -> this.webjar((String)uri);
    }

    public CharSequence webjar(Object context) {
        return HelperTools.toString(context, value -> this.webJarForUri.apply(value.toString()));
    }

    private String webjar(String uri) {
        String fullPath;
        try {
            fullPath = this.webJarAssetLocator.getFullPath(uri).replace("META-INF/resources/webjars/", "/webjars/");
        }
        catch (IllegalArgumentException e) {
            fullPath = uri;
        }
        if (fullPath.endsWith(".css")) {
            return "<link rel=\"stylesheet\" href=\"" + fullPath + "\">";
        }
        return "<script src=\"" + fullPath + "\"></script>";
    }
}

