/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.security;

import java.io.Serializable;
import java.util.stream.Stream;

public interface User
extends Serializable {
    default public String name() {
        return this.login();
    }

    public String login();

    public String[] roles();

    default public boolean isInRole(String expectedRole) {
        return Stream.of(this.roles()).anyMatch(expectedRole::equals);
    }

    public static User forLogin(String login) {
        return User.forLoginAndRoles(login, new String[0]);
    }

    public static User forLoginAndRoles(final String login, final String ... roles) {
        return new User(){

            @Override
            public String name() {
                return login;
            }

            @Override
            public String login() {
                return login;
            }

            @Override
            public String[] roles() {
                return roles;
            }
        };
    }
}

