/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.BindException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.net.ssl.SSLContext;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.ssl.SSLContextFactory;
import net.codestory.http.websockets.WebSocketHandler;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketSession;

public abstract class AbstractWebServer<T extends AbstractWebServer<T>> {
    private static final int PORT_8080 = 8080;
    private static final int RANDOM_PORT_START_RETRY = 30;
    private static final int RANDOM_PORTS_LOWER_BOUND = 8183;
    private static final int RANDOM_PORTS_COUNT = 50000;
    protected final Env env = this.createEnv();
    protected HttpServerWrapper server;
    protected RoutesProvider routesProvider;
    protected int port = -1;

    protected AbstractWebServer() {
    }

    protected abstract HttpServerWrapper createHttpServer(Handler var1, WebSocketHandler var2) throws Exception;

    public T configure(Configuration configuration) {
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, configuration) : RoutesProvider.reloading(this.env, configuration);
        return (T)this;
    }

    public T startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            try {
                int randomPort = 8183 + random.nextInt(50000);
                return this.start(randomPort);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Port already in use")) continue;
                Logs.unableToBindServer(e);
                continue;
            }
            catch (Exception e) {
                Logs.unableToBindServer(e);
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public T start() {
        return this.start(8080);
    }

    public T start(int port) {
        return this.startWithContext(port, null, false);
    }

    public T startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        return this.startSSL(port, Arrays.asList(pathCertificate), pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey) {
        return this.startSSL(port, pathChain, pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey, List<Path> pathTrustAnchors) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathChain, pathPrivateKey, pathTrustAnchors);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        boolean authReq = pathTrustAnchors != null;
        return this.startWithContext(port, context, authReq);
    }

    protected T startWithContext(int port, SSLContext context, boolean authReq) {
        try {
            this.server = this.createHttpServer(this::handleHttp, this::connectWebSocket);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
        if (this.routesProvider == null) {
            this.configure(Configuration.NO_ROUTE);
        }
        this.port = this.env.overriddenPort(port);
        try {
            Logs.mode(this.env.prodMode());
            this.server.start(this.port, context, authReq);
            Logs.started(this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof BindException || e.getCause() instanceof BindException) {
                throw new IllegalStateException("Port already in use " + this.port);
            }
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return (T)this;
    }

    public int port() {
        if (this.port == -1) {
            throw new IllegalStateException("The web server is not started");
        }
        return this.port;
    }

    public void stop() {
        try {
            this.env.folderWatcher().stop();
            this.server.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }

    protected void handleHttp(Request request, Response response) {
        RouteCollection routes = this.routesProvider.get();
        PayloadWriter payloadWriter = routes.createPayloadWriter(request, response);
        try {
            Context context = routes.createContext(request, response);
            Payload payload = routes.apply(context);
            if (payload.isError()) {
                payload = this.errorPage(payload);
            }
            payloadWriter.writeAndClose(payload);
        }
        catch (Exception e) {
            this.handleServerError(payloadWriter, e);
        }
    }

    protected void connectWebSocket(WebSocketSession session, Request request, Response response) {
        RouteCollection routes = this.routesProvider.get();
        try {
            Context context = routes.createContext(request, response);
            WebSocketListener listener = routes.createWebSocketListener(session, context);
            session.register(listener);
        }
        catch (Exception e) {
            throw new IllegalStateException("WebSocket error", e);
        }
    }

    protected void handleServerError(PayloadWriter payloadWriter, Exception e) {
        try {
            if (e instanceof CompilerException) {
                Logs.compilerError(e);
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                Logs.unexpectedError(e);
            }
            Payload errorPage = this.errorPage(e).withHeader("reason", e.getMessage());
            payloadWriter.writeAndClose(errorPage);
        }
        catch (IOException error) {
            Logs.unableToServeErrorPage(error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(payload, shownError).payload();
    }

    protected Env createEnv() {
        return new Env();
    }
}

