/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.livereload;

import java.io.IOException;
import java.util.Arrays;
import net.codestory.http.livereload.IncomingHelloMessage;
import net.codestory.http.livereload.OutgoingHelloMessage;
import net.codestory.http.livereload.OutgoingReloadMessage;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.FolderChangeListener;
import net.codestory.http.websockets.Frame;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketSession;

public class LiveReloadListener
implements WebSocketListener {
    public static final String VERSION_7 = "http://livereload.com/protocols/official-7";
    private final Env env;
    private final WebSocketSession session;
    private final FolderChangeListener listener;

    public LiveReloadListener(WebSocketSession session, Env env) {
        this.env = env;
        this.session = session;
        this.listener = () -> {
            try {
                session.send("TEXT", new OutgoingReloadMessage("path", true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        env.folderWatcher().addListener(this.listener);
    }

    @Override
    public void onFrame(Frame frame) throws IOException {
        if (frame.type().equals("TEXT")) {
            IncomingHelloMessage message = frame.as(IncomingHelloMessage.class);
            if (message.command.equals("hello")) {
                if (message.protocols.contains(VERSION_7)) {
                    this.session.send("TEXT", new OutgoingHelloMessage("Fluent-http", Arrays.asList(VERSION_7)));
                } else {
                    this.close();
                }
            }
        }
    }

    @Override
    public void onClose(int code, String reason) throws IOException {
        this.close();
    }

    private void close() throws IOException {
        this.env.folderWatcher().removeListener(this.listener);
        this.session.close();
    }
}

