/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.reload.MasterFolderWatch;

public class Env {
    private final File workingDir;
    private final boolean prodMode;
    private final boolean classPath;
    private final boolean filesystem;
    private final boolean gzip;
    private final boolean liveReloadServer;
    private final boolean injectLiveReloadScript;
    private final Supplier<MasterFolderWatch> folderWatch;

    public Env() {
        this(new File("."), Env.getBoolean("PROD_MODE", false), !Env.getBoolean("http.disable.classpath", false), !Env.getBoolean("http.disable.filesystem", false), !Env.getBoolean("http.disable.gzip", false), Env.getBoolean("http.livereload.server", true), Env.getBoolean("http.livereload.script", true));
    }

    private Env(File workingDir, boolean prodMode, boolean classPath, boolean filesystem, boolean gzip, boolean liveReloadServer, boolean injectLiveReloadScript) {
        this.workingDir = workingDir;
        this.prodMode = prodMode;
        this.classPath = classPath;
        this.filesystem = filesystem;
        this.gzip = gzip;
        this.liveReloadServer = liveReloadServer;
        this.injectLiveReloadScript = injectLiveReloadScript;
        this.folderWatch = MemoizingSupplier.memoize(() -> new MasterFolderWatch(this));
    }

    public static Env prod() {
        return new Env(new File("."), true, true, true, true, false, false);
    }

    public static Env dev() {
        return new Env(new File("."), false, true, true, false, true, true);
    }

    public Env withWorkingDir(File newWorkingDir) {
        return new Env(newWorkingDir, this.prodMode, this.classPath, this.filesystem, this.gzip, this.liveReloadServer, this.injectLiveReloadScript);
    }

    public Env withProdMode(boolean newProdMode) {
        return new Env(this.workingDir, newProdMode, this.classPath, this.filesystem, this.gzip, this.liveReloadServer, this.injectLiveReloadScript);
    }

    public Env withClassPath(boolean shouldScanCassPath) {
        return new Env(this.workingDir, this.prodMode, shouldScanCassPath, this.filesystem, this.gzip, this.liveReloadServer, this.injectLiveReloadScript);
    }

    public Env withFilesystem(boolean shouldScanFilesystem) {
        return new Env(this.workingDir, this.prodMode, this.classPath, shouldScanFilesystem, this.gzip, this.liveReloadServer, this.injectLiveReloadScript);
    }

    public Env withGzip(boolean shouldGzipResponse) {
        return new Env(this.workingDir, this.prodMode, this.classPath, this.filesystem, shouldGzipResponse, this.liveReloadServer, this.injectLiveReloadScript);
    }

    public Env withLiveReloadServer(boolean shouldStartLiveReloadServer) {
        return new Env(this.workingDir, this.prodMode, this.classPath, this.filesystem, this.gzip, shouldStartLiveReloadServer, this.injectLiveReloadScript);
    }

    public Env withInjectLiveReloadScript(boolean shouldInjectLiveReloadScript) {
        return new Env(this.workingDir, this.prodMode, this.classPath, this.filesystem, this.gzip, this.liveReloadServer, shouldInjectLiveReloadScript);
    }

    public MasterFolderWatch folderWatcher() {
        return this.folderWatch.get();
    }

    public File workingDir() {
        return this.workingDir;
    }

    public String appFolder() {
        return "app";
    }

    public List<Path> foldersToWatch() {
        ArrayList<Path> folders = new ArrayList<Path>();
        if (this.classPath) {
            folders.addAll(ClassPaths.classpathFolders());
        }
        if (this.filesystem) {
            folders.add(new File(this.workingDir, this.appFolder()).toPath());
        }
        return folders;
    }

    public boolean prodMode() {
        return this.prodMode;
    }

    public int overriddenPort(int port) {
        return Env.getInt("PORT", port);
    }

    public boolean classPath() {
        return this.classPath;
    }

    public boolean filesystem() {
        return this.filesystem;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public boolean liveReloadServer() {
        return this.liveReloadServer;
    }

    public boolean injectLiveReloadScript() {
        return this.injectLiveReloadScript;
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

