/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompiledPath;
import net.codestory.http.io.Resources;
import net.codestory.http.misc.Cache;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class StaticRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final Function<String, Object> findPath;

    StaticRoute(boolean cached) {
        this.findPath = cached ? new Cache<String, Object>(StaticRoute::findPath) : StaticRoute::findPath;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.findPath.apply(uri) != NOT_FOUND;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        return this.findPath.apply(context.uri());
    }

    private static Object findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        if (path == null || !Resources.isPublic(path)) {
            return NOT_FOUND;
        }
        if (ContentTypes.is_binary(path)) {
            return path;
        }
        return new CompiledPath(path);
    }
}

