/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Strings;
import net.codestory.http.types.ContentTypes;

public class Resources {
    public static String APP_FOLDER = "app";

    private Resources() {
    }

    @Deprecated
    public static Path appPath() {
        return Paths.get(APP_FOLDER, new String[0]);
    }

    public static String relativePath(Path parent, Path path) {
        return Resources.toUnixString(parent.relativize(path));
    }

    public static boolean isPublic(Path path) {
        for (Path part : path) {
            if (!part.toString().equals("..") && !part.toString().startsWith("_")) continue;
            return false;
        }
        return Resources.exists(path);
    }

    public static Path findExistingPath(String folder, String name) {
        return Resources.findExistingPath(folder + (name.startsWith("/") ? name : "/" + name));
    }

    public static Path findExistingPath(String uri) {
        if (uri.endsWith("/")) {
            return Resources.findExistingPath(uri + "index");
        }
        for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
            Path templatePath = Paths.get(uri + extension, new String[0]);
            if (!Resources.exists(templatePath)) continue;
            return templatePath;
        }
        return null;
    }

    public static boolean exists(Path path) {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) || Resources.existsInClassPath(pathWithPrefix);
    }

    public static String read(Path path, Charset charset) throws IOException {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) ? Resources.readFile(pathWithPrefix, charset) : Resources.readClasspath(pathWithPrefix, charset);
    }

    public static byte[] readBytes(Path path) throws IOException {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) ? Resources.readFileBytes(pathWithPrefix) : Resources.readClasspathBytes(pathWithPrefix);
    }

    private static String withPrefix(Path path) {
        return Resources.toUnixString(Paths.get(APP_FOLDER, path.toString()));
    }

    public static String toUnixString(Path path) {
        return path.toString().replace('\\', '/');
    }

    public static String extension(Path path) {
        String filename = Resources.toUnixString(path);
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex <= 0) {
            return "";
        }
        return filename.substring(dotIndex);
    }

    private static boolean existsInClassPath(String path) {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            return false;
        }
        File file = Resources.fileForClasspath(url);
        return file == null || file.isFile();
    }

    private static boolean existsInFileSystem(String path) {
        return new File(path).isFile();
    }

    private static String readClasspath(String path, Charset charset) throws IOException {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Classpath resource not found classpath:" + path);
        }
        File file = Resources.fileForClasspath(url);
        if (file != null) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Invalid file classpath: " + path);
            }
            return Resources.readFile(file.getAbsolutePath(), charset);
        }
        try (InputStream from = url.openStream();){
            String string = InputStreams.readString(from, charset);
            return string;
        }
    }

    private static byte[] readClasspathBytes(String path) throws IOException {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Invalid file classpath: " + path);
        }
        File file = Resources.fileForClasspath(url);
        if (file != null) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Invalid file classpath: " + path);
            }
            return Resources.readFileBytes(file.getAbsolutePath());
        }
        try (InputStream from = url.openStream();){
            byte[] byArray = InputStreams.readBytes(from);
            return byArray;
        }
    }

    private static String readFile(String path, Charset charset) throws IOException {
        if (!new File(path).isFile()) {
            throw new IllegalArgumentException("Invalid file path: " + path);
        }
        try (FileInputStream from = new FileInputStream(path);){
            String string = InputStreams.readString(from, charset);
            return string;
        }
    }

    private static byte[] readFileBytes(String path) throws IOException {
        if (!new File(path).isFile()) {
            throw new IllegalArgumentException("Invalid file path: " + path);
        }
        try (FileInputStream from = new FileInputStream(path);){
            byte[] byArray = InputStreams.readBytes(from);
            return byArray;
        }
    }

    static File fileForClasspath(URL url) {
        String filename = url.getFile();
        if (filename == null || filename.contains(".jar!")) {
            return null;
        }
        try {
            String path = URLDecoder.decode(filename, "US-ASCII");
            String sourcePath = Paths.get("src/main/resources/", APP_FOLDER, Strings.substringAfter(path, "/" + APP_FOLDER + "/")).toString();
            File file = new File(sourcePath);
            if (file.exists()) {
                return file;
            }
            return new File(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid filename classpath: " + url, e);
        }
    }
}

