/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.io.InputStreams;

public final class NashornCompiler {
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    NashornCompiler(String ... scriptPaths) {
        String script = this.readScripts(scriptPaths);
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            this.compiledScript = ((Compilable)((Object)nashorn)).compile(script);
            this.bindings = nashorn.getBindings(100);
        }
        catch (ScriptException e) {
            throw new IllegalStateException("Unable to compile javascript", e);
        }
    }

    private String readScripts(String ... scriptPaths) {
        StringBuilder concatenatedScript = new StringBuilder();
        for (String scriptPath : scriptPaths) {
            try (InputStream input = InputStreams.getResourceAsStream(scriptPath);){
                String content = InputStreams.readString(input, StandardCharsets.UTF_8);
                concatenatedScript.append(content).append("\n");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read script " + scriptPath, e);
            }
        }
        return concatenatedScript.toString();
    }

    public synchronized String compile(Path path, String source) {
        this.bindings.put("__filename", (Object)path.getFileName());
        this.bindings.put("__source", (Object)source);
        try {
            return this.compiledScript.eval(this.bindings).toString();
        }
        catch (ScriptException e) {
            String message = NashornCompiler.cleanMessage(path, e.getCause().getMessage());
            throw new CompilerException(message);
        }
    }

    private static String cleanMessage(Path path, String message) {
        return message.replace("Unable to compile CoffeeScript [stdin]:", "Unable to compile " + path + ":");
    }
}

