/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.BindException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.net.ssl.SSLContext;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.filters.log.LogRequestFilter;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleServerWrapper;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.ConfigurationReloadingProxy;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.ssl.SSLContextFactory;
import net.codestory.http.templating.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Logger LOG = LoggerFactory.getLogger(WebServer.class);
    private final HttpServerWrapper server;
    private Env env;
    private RoutesProvider routesProvider;
    private int port;

    public WebServer() {
        this(Configuration.NO_ROUTE);
    }

    public WebServer(Class<? extends Configuration> configuration) {
        this(new ConfigurationReloadingProxy(configuration));
    }

    public WebServer(Configuration configuration) {
        try {
            this.server = new SimpleServerWrapper(this::handle);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
        this.configure(configuration);
    }

    public static void main(String[] args) throws Exception {
        new WebServer(routes -> routes.filter(new LogRequestFilter())).start(8080);
    }

    public WebServer configure(Configuration configuration) {
        this.env = new Env();
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, configuration) : RoutesProvider.reloading(this.env, configuration);
        return this;
    }

    public WebServer startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            try {
                int port = 8183 + random.nextInt(10000);
                this.start(port);
                return this;
            }
            catch (Exception e) {
                LOG.error("Unable to bind server", (Throwable)e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public WebServer start() {
        return this.start(8080);
    }

    public WebServer start(int port) {
        return this.startWithContext(port, null, false);
    }

    public WebServer startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        return this.startSSL(port, Arrays.asList(pathCertificate), pathPrivateKey, null);
    }

    public WebServer startSSL(int port, List<Path> pathChain, Path pathPrivateKey) {
        return this.startSSL(port, pathChain, pathPrivateKey, null);
    }

    public WebServer startSSL(int port, List<Path> pathChain, Path pathPrivateKey, List<Path> pathTrustAnchors) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathChain, pathPrivateKey, pathTrustAnchors);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        boolean authReq = pathTrustAnchors != null;
        return this.startWithContext(port, context, authReq);
    }

    private WebServer startWithContext(int port, SSLContext context, boolean authReq) {
        this.port = this.env.overriddenPort(port);
        try {
            LOG.info(this.env.prodMode() ? "Production mode" : "Dev mode");
            this.server.start(this.port, context, authReq);
            LOG.info("Server started on port {}", (Object)this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (BindException e) {
            throw new IllegalStateException("Port already in use " + this.port);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return this;
    }

    public int port() {
        return this.port;
    }

    public void reset() {
        this.configure(Configuration.NO_ROUTE);
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }

    void handle(Request request, Response response) {
        try {
            RouteCollection routes = this.routesProvider.get();
            Context context = routes.createContext(request, response);
            PayloadWriter payloadWriter = routes.createPayloadWriter(request, response);
            Payload payload = routes.apply(context);
            if (payload.isError()) {
                payload = this.errorPage(payload);
            }
            payloadWriter.writeAndClose(payload);
        }
        catch (Exception e) {
            PayloadWriter payloadWriter = new PayloadWriter(this.env, new Site(), request, response);
            this.handleServerError(payloadWriter, e);
        }
    }

    protected void handleServerError(PayloadWriter payloadWriter, Exception e) {
        try {
            if (e instanceof CompilerException) {
                LOG.error(e.getMessage());
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                e.printStackTrace();
            }
            payloadWriter.writeAndClose(this.errorPage(e));
        }
        catch (IOException error) {
            LOG.warn("Unable to serve an error page", (Throwable)error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(payload, shownError).payload();
    }
}

