/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.websockets;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.websockets.WebSocketListener;

public interface WebSocketSession {
    public void register(WebSocketListener var1) throws IOException;

    public void remove(WebSocketListener var1) throws IOException;

    public void close() throws IOException;

    public void close(String var1, String var2) throws IOException;

    public void send(String var1, byte[] var2) throws IOException;

    public Map<Object, Object> getAttributes();

    default public Object getAttribute(Object key) {
        return this.getAttributes().get(key);
    }

    default public void send(String type, String message) throws IOException {
        this.send(type, message.getBytes(StandardCharsets.UTF_8));
    }

    default public void send(String type, Object object) throws IOException {
        this.send(type, TypeConvert.toByteArray(object));
    }
}

