/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Handlebars;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.misc.Cache;
import net.codestory.http.misc.Sha1;
import org.webjars.WebJarAssetLocator;

public class AssetsHelperSource {
    private final Resources resources;
    private final CompilerFacade compilers;
    private final Function<String, String> urlSupplier;
    private final WebJarAssetLocator webJarAssetLocator;

    public AssetsHelperSource(boolean prodMode, Resources resources, CompilerFacade compilers) {
        this.resources = resources;
        this.compilers = compilers;
        this.urlSupplier = prodMode ? new Cache<String, String>(p -> this.uriWithSha1((String)p)) : path -> this.uriWithSha1((String)path);
        this.webJarAssetLocator = new WebJarAssetLocator();
    }

    public CharSequence script(Object context) {
        return AssetsHelperSource.toString(context, value -> this.singleScript(value.toString()));
    }

    public CharSequence css(Object context) {
        return AssetsHelperSource.toString(context, value -> this.singleCss(value.toString()));
    }

    public CharSequence webjar(Object context) {
        return AssetsHelperSource.toString(context, value -> this.singleWebjar(value.toString()));
    }

    private static CharSequence toString(Object context, Function<Object, CharSequence> transform) {
        return new Handlebars.SafeString((CharSequence)AssetsHelperSource.contextAsList(context).stream().map(transform).collect(Collectors.joining("\n")));
    }

    private static List<Object> contextAsList(Object context) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (context instanceof Iterable) {
            for (Object value : (Iterable)context) {
                list.add(value);
            }
        } else {
            list.add(context);
        }
        return list;
    }

    private CharSequence singleScript(Object context) {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".js");
        return "<script src=\"" + this.uriWithSha1(uri) + "\"></script>";
    }

    private CharSequence singleCss(Object context) {
        String uri = AssetsHelperSource.addExtensionIfMissing(context.toString(), ".css");
        return "<link rel=\"stylesheet\" href=\"" + this.urlSupplier.apply(uri) + "\">";
    }

    private CharSequence singleWebjar(Object context) {
        String fullPath;
        String uri = context.toString();
        try {
            fullPath = this.webJarAssetLocator.getFullPath(uri).replace("META-INF/resources/webjars/", "/webjars/");
        }
        catch (IllegalArgumentException e) {
            fullPath = uri;
        }
        if (fullPath.endsWith(".css")) {
            return "<link rel=\"stylesheet\" href=\"" + fullPath + "\">";
        }
        return "<script src=\"" + fullPath + "\"></script>";
    }

    private static String addExtensionIfMissing(String uri, String extension) {
        return uri.endsWith(extension) ? uri : uri + extension;
    }

    private String uriWithSha1(String uri) {
        try {
            Path path = this.resources.findExistingPath(uri);
            if (path != null && this.resources.isPublic(path)) {
                return uri + '?' + Sha1.of(this.resources.readBytes(path));
            }
            Path sourcePath = this.compilers.findPublicSourceFor(uri);
            if (sourcePath != null) {
                return uri + '?' + Sha1.of(this.resources.readBytes(sourcePath));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to compute sha1 for: " + uri, e);
        }
        return uri;
    }
}

