/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.io.FileVisitor;
import net.codestory.http.reload.FolderChangeListener;
import net.codestory.http.reload.WatchServiceFacade;

public class NativeWatchService
implements WatchServiceFacade {
    private final WatchService watcher;
    private final AtomicBoolean run = new AtomicBoolean(false);

    public NativeWatchService(Path folder) {
        try {
            this.watcher = folder.getFileSystem().newWatchService();
            Files.walkFileTree(folder, FileVisitor.onDirectory(dir -> dir.register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to watch folder " + folder, e);
        }
    }

    @Override
    public void stop() {
        this.run.set(false);
    }

    @Override
    public void onChange(FolderChangeListener listener) {
        new Thread(() -> {
            this.run.set(true);
            while (this.run.get()) {
                try {
                    WatchKey take = this.watcher.take();
                    boolean changed = false;
                    for (WatchEvent<?> event : take.pollEvents()) {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                        changed = true;
                    }
                    if (changed) {
                        listener.onChange();
                    }
                    take.reset();
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }
}

