/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.nio.file.Path;
import net.codestory.http.reload.FolderChangeListener;
import net.codestory.http.reload.NativeWatchService;
import net.codestory.http.reload.OsxWatchService;
import net.codestory.http.reload.WatchServiceFacade;

public class FolderWatcher {
    private final Path folder;
    private final FolderChangeListener listener;
    private WatchServiceFacade watcher;
    private boolean started;

    public FolderWatcher(Path folder, FolderChangeListener listener) {
        this.folder = folder;
        this.listener = listener;
    }

    public void ensureStarted() {
        if (this.started) {
            return;
        }
        if (!this.folder.toFile().exists()) {
            return;
        }
        this.watcher = FolderWatcher.isMac() ? new OsxWatchService(this.folder) : new NativeWatchService(this.folder);
        this.watcher.onChange(this.listener);
        this.started = true;
    }

    public void stop() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    private static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }
}

