/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class InputStreams {
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };

    private InputStreams() {
    }

    public static byte[] readBytes(InputStream from) throws IOException {
        return InputStreams.read(from, bytes -> bytes.toByteArray());
    }

    public static String readString(InputStream from, Charset charset) throws IOException {
        return InputStreams.read(from, bytes -> bytes.toString(charset.name()));
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        int count;
        byte[] buffer = BUFFER.get();
        while (-1 != (count = from.read(buffer))) {
            to.write(buffer, 0, count);
        }
    }

    public static <T> T read(InputStream from, ForBytes<T> transform) throws IOException {
        byte[] buffer = BUFFER.get();
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            int count;
            while (-1 != (count = from.read(buffer))) {
                bytes.write(buffer, 0, count);
            }
            T t = transform.apply(bytes);
            return t;
        }
    }

    public static InputStream getResourceAsStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    @FunctionalInterface
    private static interface ForBytes<T> {
        public T apply(ByteArrayOutputStream var1) throws IOException;
    }
}

