/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.util.Map;
import net.codestory.http.internal.SimpleFrame;
import net.codestory.http.internal.Unwrappable;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketSession;
import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.DataFrame;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameChannel;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.Session;

class SimpleWebSocketSession
implements WebSocketSession,
Unwrappable {
    private final Session session;

    SimpleWebSocketSession(Session session) {
        this.session = session;
    }

    private FrameChannel channel() {
        return this.session.getChannel();
    }

    @Override
    public void remove(WebSocketListener listener) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.session.getAttributes();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    @Override
    public void register(final WebSocketListener listener) throws IOException {
        this.channel().register(new FrameListener(){

            public void onFrame(Session session, Frame frame) {
                FrameType type = frame.getType();
                if (!type.isPing() && !type.isPong()) {
                    try {
                        listener.onFrame(new SimpleFrame(frame));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to handle frame", e);
                    }
                }
            }

            public void onError(Session session, Exception cause) {
                try {
                    listener.onError(cause);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to handle error", e);
                }
            }

            public void onClose(Session session, Reason reason) {
                try {
                    listener.onClose(reason.getCode().code, reason.getText());
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to handle close", e);
                }
            }
        });
    }

    @Override
    public void send(String type, String message) throws IOException {
        this.channel().send((Frame)new DataFrame(FrameType.valueOf((String)type), message));
    }

    @Override
    public void send(String type, byte[] message) throws IOException {
        this.channel().send((Frame)new DataFrame(FrameType.valueOf((String)type), message));
    }

    @Override
    public void close() throws IOException {
        this.channel().close();
    }

    @Override
    public void close(String code, String reason) throws IOException {
        this.channel().close(new Reason(CloseCode.valueOf((String)code), reason));
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this.session) ? this.session : null);
    }
}

