/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.codestory.http.misc.Md5;

public class SSLContextFactory {
    public SSLContext create(List<Path> pathCertificates, Path pathPrivateKey, List<Path> pathTrustAnchors) throws GeneralSecurityException, IOException {
        Certificate[] chain = (X509Certificate[])pathCertificates.stream().map(path -> {
            try {
                return SSLContextFactory.generateCertificateFromDER(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray(X509Certificate[]::new);
        RSAPrivateKey key = SSLContextFactory.generatePrivateKeyFromDER(pathPrivateKey);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", chain[0]);
        keystore.setKeyEntry("key-alias", key, new char[0], chain);
        KeyStore truststore = null;
        if (pathTrustAnchors != null && !pathTrustAnchors.isEmpty()) {
            X509Certificate[] trustAnchors = (X509Certificate[])pathTrustAnchors.stream().map(path -> {
                try {
                    return SSLContextFactory.generateCertificateFromDER(Files.readAllBytes(path));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).toArray(X509Certificate[]::new);
            truststore = KeyStore.getInstance("JKS");
            truststore.load(null);
            for (X509Certificate certificate : trustAnchors) {
                truststore.setCertificateEntry(Md5.of(certificate.getEncoded()), certificate);
            }
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SSLContextFactory.getKeyManagers(keystore), SSLContextFactory.getTrustManagers(truststore), null);
        return context;
    }

    private static KeyManager[] getKeyManagers(KeyStore keyStore) throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, new char[0]);
        return kmf.getKeyManagers();
    }

    private static X509Certificate generateCertificateFromDER(Path path) throws GeneralSecurityException, IOException {
        return SSLContextFactory.generateCertificateFromDER(Files.readAllBytes(path));
    }

    private static TrustManager[] getTrustManagers(KeyStore trustStore) throws GeneralSecurityException {
        if (trustStore == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    private static X509Certificate generateCertificateFromDER(byte[] data) throws GeneralSecurityException {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data));
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(Path path) throws GeneralSecurityException, IOException {
        return SSLContextFactory.generatePrivateKeyFromDER(Files.readAllBytes(path));
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] data) throws GeneralSecurityException {
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(data));
    }
}

