/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.codestory.http.payload.Payload;
import net.codestory.http.templating.ModelAndView;

public class ErrorPage {
    private final Payload payload;
    private final Exception exception;

    public ErrorPage(Payload payload, Exception exception) {
        this.payload = payload;
        this.exception = exception;
    }

    public Payload payload() {
        String error = ErrorPage.toString(this.exception);
        String filename = this.filename();
        return new Payload("text/html", ModelAndView.of(filename, "ERROR", error), this.payload.code()).withHeaders(this.payload.headers()).withCookies(this.payload.cookies());
    }

    private String filename() {
        return this.payload.code() == 404 ? "404.html" : "500.html";
    }

    private static String toString(Exception error) {
        if (error == null) {
            return "";
        }
        StringWriter string = new StringWriter();
        try (PrintWriter message = new PrintWriter(string);){
            error.printStackTrace(message);
        }
        return ((Object)string).toString();
    }
}

