/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.PathSource;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Resources;

public class LessCompiler
implements Compiler {
    private final Resources resources;
    private final boolean inline;

    public LessCompiler(Resources resources, boolean prodMode) {
        this.resources = resources;
        this.inline = !prodMode;
    }

    @Override
    public String compile(SourceFile sourceFile) {
        try {
            LessCompiler.Configuration configuration = new LessCompiler.Configuration();
            this.configureSourceMap(configuration);
            return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(this.resources, sourceFile), configuration).getCss();
        }
        catch (Less4jException e) {
            String message = LessCompiler.cleanMessage(sourceFile, e.getMessage());
            throw new CompilerException(message);
        }
    }

    private void configureSourceMap(LessCompiler.Configuration configuration) {
        LessCompiler.SourceMapConfiguration sourceMaps = configuration.getSourceMapConfiguration();
        sourceMaps.setLinkSourceMap(false);
        sourceMaps.setInline(this.inline);
    }

    private static String cleanMessage(SourceFile sourcefile, String message) {
        return "Unable to compile less " + sourcefile.getFileName() + ": " + message.replace("Could not compile less. ", "");
    }
}

