/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codestory.http.io.FileVisitor;
import net.codestory.http.io.Resources;

public class ClassPaths {
    private ClassPaths() {
    }

    public static URL[] getUrls(ClassLoader parent) {
        if (!(parent instanceof URLClassLoader)) {
            return new URL[0];
        }
        return (URL[])Stream.of(((URLClassLoader)parent).getURLs()).filter(url -> !url.toString().endsWith(".jar")).toArray(URL[]::new);
    }

    public static URL getResource(String path) {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public static List<String> fromURL(URL url) {
        String protocol = url.getProtocol();
        String name = url.toExternalForm();
        if ("file".equals(protocol)) {
            try {
                File file = ClassPaths.getFile(url);
                return name.contains(".jar") ? ClassPaths.forJarFile(new JarFile(file)) : ClassPaths.forSystemDir(file);
            }
            catch (Throwable file) {
                // empty catch block
            }
        }
        try {
            List<String> relativePaths;
            if ("jar".equals(protocol) && (relativePaths = ClassPaths.forJarUrl(url)) != null) {
                return relativePaths;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static File getFile(URL url) {
        String path2;
        try {
            path2 = url.toURI().getSchemeSpecificPart();
            if (new File(path2).exists()) {
                return new File(path2);
            }
        }
        catch (URISyntaxException path2) {
            // empty catch block
        }
        try {
            path2 = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.displayName());
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.lastIndexOf(".jar!") + ".jar".length());
            }
            if (new File(path2).exists()) {
                return new File(path2);
            }
        }
        catch (UnsupportedEncodingException path3) {
            // empty catch block
        }
        try {
            path2 = url.toExternalForm();
            if (path2.startsWith("jar:")) {
                path2 = path2.substring("jar:".length());
            } else if (path2.startsWith("file:")) {
                path2 = path2.substring("file:".length());
            }
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.indexOf(".jar!") + ".jar".length());
            }
            if (new File(path2).exists()) {
                return new File(path2);
            }
            if (new File(path2 = path2.replace("%20", " ")).exists()) {
                return new File(path2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<String> forJarUrl(URL url) throws IOException {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                return ClassPaths.forJarFile(((JarURLConnection)urlConnection).getJarFile());
            }
        }
        catch (Throwable urlConnection) {
            // empty catch block
        }
        File file = ClassPaths.getFile(url);
        if (file == null) {
            return null;
        }
        return ClassPaths.forJarFile(new JarFile(file));
    }

    private static List<String> forJarFile(JarFile jarFile) {
        return jarFile.stream().filter(entry -> !entry.isDirectory()).map(entry -> entry.getName()).collect(Collectors.toList());
    }

    private static List<String> forSystemDir(File file) throws IOException {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        Path parent = file.toPath();
        ArrayList<String> files = new ArrayList<String>();
        Files.walkFileTree(parent, FileVisitor.onFile(path2 -> files.add(Resources.relativePath(parent, path2))));
        return files;
    }
}

