/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleRequest;
import net.codestory.http.internal.SimpleResponse;
import net.codestory.http.internal.SimpleWebSocketSession;
import net.codestory.http.websockets.WebSocketHandler;
import net.codestory.http.websockets.WebSocketListener;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.DirectRouter;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.RouterContainer;
import org.simpleframework.http.socket.service.Service;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketConnection;

public class SimpleServerWrapper
implements HttpServerWrapper,
Container,
Service {
    private final Handler httpHandler;
    private final WebSocketHandler webSocketHandler;
    private final int count;
    private final int select;
    private SocketConnection socketConnection;

    public SimpleServerWrapper(Handler httpHandler, WebSocketHandler webSocketHandler) {
        this(httpHandler, webSocketHandler, 8, 1);
    }

    public SimpleServerWrapper(Handler httpHandler, WebSocketHandler webSocketHandler, int count, int select) {
        this.httpHandler = httpHandler;
        this.webSocketHandler = webSocketHandler;
        this.count = count;
        this.select = select;
    }

    @Override
    public void start(int port, SSLContext context, boolean authReq) throws IOException {
        DirectRouter router = new DirectRouter((Service)this);
        RouterContainer routerContainer = new RouterContainer((Container)this, (Router)router, 10);
        ContainerSocketProcessor server = new ContainerSocketProcessor((Container)routerContainer, this.count, this.select);
        this.socketConnection = new SocketConnection((SocketProcessor)(authReq ? new AuthRequiredServer((SocketProcessor)server) : server));
        this.socketConnection.connect((SocketAddress)new InetSocketAddress(port), context);
    }

    public void handle(Request request, Response response) {
        this.httpHandler.handle(this.createRequest(request), this.createResponse(response));
    }

    public void connect(Session session) {
        final WebSocketListener delegate = this.webSocketHandler.create(this.createRequest(session.getRequest()), this.createResponse(session.getResponse()));
        final SimpleWebSocketSession webSocketSession = new SimpleWebSocketSession(session);
        try {
            session.getChannel().register(new FrameListener(){

                public void onFrame(Session session, Frame frame) {
                    FrameType type = frame.getType();
                    if (!type.isPing() && !type.isPong()) {
                        delegate.onFrame(webSocketSession, type.name(), () -> frame.getText());
                    }
                }

                public void onError(Session session, Exception cause) {
                    delegate.onError(webSocketSession, cause);
                }

                public void onClose(Session session, Reason reason) {
                    delegate.onClose(webSocketSession, reason.getCode().code, reason.getText());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("WebSocket error", e);
        }
    }

    private SimpleRequest createRequest(Request request) {
        return new SimpleRequest(request);
    }

    private SimpleResponse createResponse(Response response) {
        return new SimpleResponse(response);
    }

    @Override
    public void stop() throws IOException {
        this.socketConnection.close();
    }

    private static class AuthRequiredServer
    implements SocketProcessor {
        private final SocketProcessor delegate;

        AuthRequiredServer(SocketProcessor delegate) {
            this.delegate = delegate;
        }

        public void process(Socket socket) throws IOException {
            socket.getEngine().setNeedClientAuth(true);
            this.delegate.process(socket);
        }

        public void stop() throws IOException {
            this.delegate.stop();
        }
    }
}

