/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.helpers.EachReverseHelperSource;
import net.codestory.http.templating.helpers.EachValueHelperSource;
import net.codestory.http.templating.helpers.GoogleAnalyticsHelper;

public enum HandlebarsCompiler {
    INSTANCE;

    private final Handlebars handlebars = HandlebarsCompiler.handlebars();
    private final List<ValueResolver> resolvers = new ArrayList<ValueResolver>(Arrays.asList(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE}));

    public String compile(String template, Map<String, ?> variables) throws IOException {
        return this.handlebars.compileInline(template).apply(this.context(variables));
    }

    private static Handlebars handlebars() {
        Handlebars hb = new Handlebars();
        hb.startDelimiter("[[");
        hb.endDelimiter("]]");
        hb.registerHelpers((Object)new EachReverseHelperSource());
        hb.registerHelpers((Object)new EachValueHelperSource());
        hb.registerHelpers((Object)new GoogleAnalyticsHelper());
        hb.registerHelpers(StringHelpers.class);
        hb.with((TemplateCache)new ConcurrentMapTemplateCache());
        hb.with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) throws IOException {
                Path include = Resources.findExistingPath("_includes", location);
                if (include == null) {
                    throw new IOException("Template not found " + location);
                }
                String template = Resources.read(include, StandardCharsets.UTF_8);
                CacheEntry compiled = Compilers.INSTANCE.compile(include, template);
                return new StringTemplateSource(location, compiled.content());
            }
        }});
        return hb;
    }

    private Context context(Map<String, ?> variables) {
        return Context.newBuilder(null).resolver(this.resolvers.toArray(new ValueResolver[this.resolvers.size()])).combine(variables).build();
    }

    public void addResolver(ValueResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void registerHelper(Class<?> helperSource) {
        this.handlebars.registerHelpers(helperSource);
    }

    public void registerHelper(Object helperSource) {
        this.handlebars.registerHelpers(helperSource);
    }
}

